###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_buildbot_detect.nasl 4302 2009-09-10 11:44:19Z sep $
#
# Buildbot Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800933);
  script_version("Revision: 1.0 ");
  script_name("Buildbot Version Detection");
  desc = "

  Overview : This script detects the installed version of Buildbot
  and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of Buildbot");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 8010);
  exit(0);
}


include("http_func.inc");

buildbotPort = get_http_port(default:8010);
if(!buildbotPort){
  buildbotPort = 8010;
}

if(!get_port_state(buildbotPort)){
  exit(0);
}

foreach dir (make_list("/", "/buildbot", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/about", port:buildbotPort);
  rcvRes = http_send_recv(port:buildbotPort, data:sndReq);

  if("Buildbot" >< rcvRes)
  {
    buildbotVer = eregmatch(pattern:"Buildbot.?.?(([0-9.]+)([a-z][0-9]+)?)",
                            string:rcvRes);

    if(!isnull(buildbotVer[2]))
    {
      if(!isnull(buildbotVer[3]))
        buildbotVer = buildbotVer[2] + "." + buildbotVer[3];
      else
        buildbotVer = buildbotVer[2];
      set_kb_item(name:"Buildbot/Ver", value:buildbotVer);
    }
  }
}
