###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bsplayer_srt_bof_vuln.nasl 1455 2009-04-06 16:45:29Z apr $
#
# BSPlayer Stack Overflow Vulnerability SRT
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800270);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6583");
  script_bugtraq_id(28811);
  script_name("BSPlayer Stack Overflow Vulnerability SRT");
  desc = "

  Overview: This host is running BSPlayer Free Edition and is prone to Stack
  Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is due to boundary check error while the user supplies input data
  in the context of the application.

  Impact:
  Successful exploitation will let the attacker craft a malicious arbitrary
  'srt' file and cause stack overflow in the context of the affected
  application or can also cause remote code execution.

  Impact level: System/Application

  Affected Software/OS:
  BSPlayer version 2.27.958 and prior on Windows.

  Fix: No solution or patch is available as on 07th April, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For further information refer, http://www.bsplayer.org

  References:
  http://www.milw0rm.com/exploits/5455
  http://xforce.iss.net/xforce/xfdb/41841
  http://www.vupen.com/english/advisories/2008/1243/references

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of BSPlayer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_bsplayer_detect.nasl");
  script_require_keys("BSPlayer/Ver");
  exit(0);
}


include("version_func.inc");

playerVer = get_kb_item("BSPlayer/Ver");
if(playerVer != NULL)
{
  # Grep for BSPlayer Free Edition version prior to 2.27.958
  if(version_is_less_equal(version:playerVer, test_version:"2.27.958")){
    security_hole(0);
  }
}
