##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bsplayer_detect.nasl 1261 2009-03-30 17:30:24Z mar $
#
# BS Player Free Edition Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800268);
  script_version("$Revision: 1.0 $");
  script_name("BS Player Free Edition Version Detection");
  desc = "
  Overview : This script finds the installed version of BS Player Free Edition
  and saves the version in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of BS Player Free Edition in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Method 1
key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(registry_key_exists(key:key)){
   
  foreach item (registry_enum_keys(key:key))
  {
    bsName = registry_get_sz(key:key + item, item:"DisplayName");
    if("BS.Player" >< bsName)
    {
      bsVer = registry_get_sz(key:key + item, item:"DisplayVersion");
      if(bsVer != NULL)
      {
        set_kb_item(name:"BSPlayer/Ver", value:bsVer);
        exit(0);
      }
    }
  }
}

# Method 2
key2 = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key2)){
    exit(0);
}

foreach item (registry_enum_keys(key:key2))
{
  bsName = registry_get_sz(key:key2 + item, item:"DisplayName");
  if("BS.Player" >< bsName || "BSPlayer" >< bsName)
  {
    path = registry_get_sz(key:key2 + item, item:"UninstallString");
    if(path != NULL)
    {
      exePath = ereg_replace(pattern:'\"(.*)\"', replace:"\1", string:path);
      exePath = exePath - "uninstall.exe" + "bsplayer.exe";

      share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
      file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);
    }

    soc = open_sock_tcp(port);
    if(!soc){
      exit(0);
    }

    r = smb_session_request(soc:soc, remote:name);
    if(!r)
    {
      close(soc);
      exit(0);
    }

    prot = smb_neg_prot(soc:soc);
    if(!prot)
    {
      close(soc);
      exit(0);
    }

    r = smb_session_setup(soc:soc, login:login, password:pass,
                          domain:domain, prot:prot);
    if(!r)
    {
      close(soc);
      exit(0);
    }

    uid = session_extract_uid(reply:r);
    r = smb_tconx(soc:soc, name:name, uid:uid, share:share);

    tid = tconx_extract_tid(reply:r);
    if(!tid)
    {
      close(soc);
      exit(0);
    }

    fid = OpenAndX(socket:soc, uid:uid, tid:tid, file:file);
    if(!fid)
    {
      close(soc);
      exit(0);
    }

    v = GetVersion(socket:soc, uid:uid, tid:tid, fid:fid, verstr:"prod",
                   offset:600000);
    close(soc);
    if(v != NULL){
      set_kb_item(name:"BSPlayer/Ver", value:v);
    }
    exit(0);
  }
}
