###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bpsoft_hex_workshop_cmpa_dos_vuln.nasl 799 2009-01-02 18:08:24Z jan $
#
# BreakPoint Software Hex Workshop Denial of Service vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800327);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5756");
  script_bugtraq_id(33023);
  script_name("BreakPoint Software Hex Workshop Denial of Service vulnerability");
  desc = "

  Overview: This host has Hex Workshop installed and is prone to Denial of
  Service vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper boundary checks in Color Mapping or
  .cmap file via a long mapping reference.

  Impact:
  Successful exploitation will allow attackers to execute arbitrary code and
  can cause Denial of Service to the application.

  Impact Level: Application

  Affected Software/OS:
  BreakPoint Software Hex Workshop version 5.1.4 and prior on Windows.

  Fix: No solution or patch is available as on 06th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.bpsoft.com/downloads

  References:
  http://secunia.com/Advisories/33327
  http://www.milw0rm.com/exploits/7592

  CVSS Score:
    CVSS Base Score      : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score  : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Hex Workshop");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_bpsoft_hex_workshop_detect.nasl");
  exit(0);
}


include("version_func.inc");

hwVer = get_kb_item("BPSoft/HexWorkshop/Ver");
if(!hwVer){
  exit(0);
}

# Check for version 5.1.4.4188 and prior
if(version_in_range(version:hwVer, test_version:"1.0",
                                   test_version2:"5.1.4.4188")){
  security_hole(0);
}
