##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bournal_privilege_escalation_vuln.nasl 7435 2010-03-02 17:20:29 mar $
#
# Bournal Privilege Escalation Vulnerability
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################i###############################################

if(description)
{
  script_id(800730);
  script_version("$Revision: 6915 $: 1.0");
  script_bugtraq_id(38353);
  script_cve_id("CVE-2010-0118");
  script_name("Bournal Privilege Escalation Vulnerability");
  desc = "
  Overview: This host is installed with Bournal and is prone to privilege
  escalation vulnerability

  Vulnerability Insight:
  The flaw exists while using temporary files in an insecure manner, which may
  allow attackers to overwrite arbitrary files via symlink attacks when running
  the update check via the '--hack_the_gibson' parameter.

  Impact:
  Successful exploitation will allow attackers to perform certain actions with
  escalated privileges.

  Impact Level: Application.

  Affected Software :
  Bournal version prior to 1.4.1

  Fix: Upgarde to Bournal 1.4.1
  For updates refer, http://becauseinter.net/bournal/

  References:
  http://secunia.com/advisories/38554
  http://secunia.com/secunia_research/2010-6/

  CVSS Score:
    CVSS Base Score      : 3.3 (AV:L/AC:M/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score  : 2.5
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Bournal");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Privilege escalation");
  script_dependencies("gb_bournal_detect.nasl");
  exit(0);
}


include("version_func.inc");

bourVer = get_kb_item("Bournal/Ver");
if(!bourVer){
  exit(0);
}

if(version_is_less(version:bourVer, test_version:"1.4.1")){
   security_warning(0);
}
