###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_bournal_detect.nasl 7435 2010-03-03 16:30:11Z mar $
#
# Bournal Version Detection
#
# Authors:
# Madhuri D <dmadhuri@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800300);
  script_version("$Revision: 6915 $: 1.0");
  script_name("Bournal Version Detection");
  desc = "
  Overview : This script finds the Bournal installed version and save
  the version in KB.

  Risk factor : Informational";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_summary("Set the version of Bournal in KB");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

bourName = find_bin(prog_name:"bournal", sock:sock);
foreach binary_bourName (bourName)
{
  bourVer = get_bin_version(full_prog_name:chomp(binary_bourName), version_argv:"-v",
                           ver_pattern:"Bournal ([0-9.]+)", sock:sock);
  if(!isnull(bourVer[1])){
    set_kb_item(name:"Bournal/Ver", value:bourVer[1]);
  }
}
ssh_close_connection();
