###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_blob_blog_system_postid_xss_vuln.nasl 5241 2009-10-20 13:46:09Z oct $
#
# BLOB Blog System 'postid' Parameter XSS Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800956);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3594");
  script_name("BLOB Blog System 'postid' Parameter XSS Vulnerability");
  desc = "
  Overview: This host is running BLOB Blog System and is prone to Cross-Site
  Scripting vulnerability.

  Vulnerability Insight:
  This flaw is caused due to improper validation of user supplied data passed
  into the 'postid' parameter in the bpost.php.

  Impact:
  Successful exploitation will allow remote attackers to execute arbitrary HTML
  and script code in a user's browser session in the context of an affected
  site.

  Impact Level: Application

  Affected Software/OS:
  BLOB Blog System prior to 1.2 on all platforms.

  Fix: Upgrade to BLOB Blog System 1.2 or later.
  http://sourceforge.net/projects/blobblogsystem/files/

  References:
  http://secunia.com/advisories/35938/
  http://xforce.iss.net/xforce/xfdb/51959

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of BLOB Blog System");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_blob_blog_system_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

bbsPort = get_http_port(default:80);
if(!bbsPort){
  exit(0);
}

bbsVer = get_kb_item("www/" + bbsPort + "/BLOB-Blog-System");
bbsVer = eregmatch(pattern:"^(.+) under (/.*)$", string:bbsVer);

if(bbsVer[1] != NULL)
{
  if(version_is_less(version:bbsVer[1], test_version:"1.2")){
    security_warning(bbsPort);
  }
}
