###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_backuppc_clientnamealias_sec_bypass_vuln.nasl 5063 2009-10-06 17:52:24Z oct $
#
# BackupPC 'ClientNameAlias' Function Security Bypass Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801107);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3369");
  script_name("BackupPC 'ClientNameAlias' Function Security Bypass Vulnerability");
  desc = "
  Overview: This host has BackupPC intallation and is prone to security bypass
  vulnerability.

  Vulnerability Insight:
  The security issue is caused due to the application allowing users to set the
  'ClientNameAlias' option for configured hosts. This can be exploited to backup
  arbitrary directories from client systems for which Rsync over SSH is
  configured as a transfer method.

  Impact:
  Successful attacks may allow remote authenticated users to read and write
  sensitive files by modifying ClientNameAlias to match another system, then
  initiating a backup or restore on the victim's system.

  Impact Level: System

  Affected Software/OS:
  BackupPC version 3.1.0 and prior.

  Fix:
  No solution or patch is available as on 06th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://backuppc.sourceforge.net/
  or
  For Debian platform Update to version 3.1.0-7 from below link,
  https://launchpad.net/debian/+source/backuppc/3.1.0-7
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=542218

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://osvdb.org/57236
  http://secunia.com/advisories/36393
  http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=542218

  CVSS Score:
    CVSS Base Score     : 8.5 (AV:N/AC:M/Au:SI/C:C/I:C/A:C)
    CVSS Temporal Score : 6.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of BackupPC");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_backuppc_detect.nasl");
  script_require_keys("BackupPC/Ver");
  exit(0);
}


include("version_func.inc");

backuppcVer = get_kb_item("BackupPC/Ver");
if(backuppcVer)
{
  # Check for BackupPC version <= 3.1.0
  if(version_in_range(version:backuppcVer, test_version:"3.0",
                                           test_version2:"3.1.0")){
     security_hole(0);
  }
}
