###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_avast_av_mult_bof_vuln_lin.nasl 3254 2009-07-07 15:43:23Z jul $
#
# avast! AntiVirus Multiple BOF Vulnerabilities (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800599);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2008-6846");
  script_bugtraq_id(32747);
  script_name("avast! AntiVirus Multiple BOF Vulnerabilities (Linux)");
  desc = "

  Overview: The host is installed with avast! AntiVirus and is prone to
  multiple Buffer Overflow Vulnerabilities.

  Vulnerability Insight:
  Multiple buffer overflow errors occur while processing malformed ISO or
  RPM files as the application fails to perform adequate bounds check on
  files before copying them into an insufficiently sized buffer.

  Impact:
  Attackers can exploit this issue to execute arbitrary code in the context
  of affected application, and can cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  avast! Linux Home Edition 1.0.8-2 and prior on Linux

  Fix: Upgrade to avast! Linux Home Edition latest version
  http://www.avast.com/index.html

  References:
  http://xforce.iss.net/xforce/xfdb/47251
  http://en.securitylab.ru/nvd/382096.php
  http://www.vupen.com/english/advisories/2008/3460

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.0
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of avast! Linux Home Edition");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_avast_av_detect_lin.nasl");
  script_require_keys("Avast!/AV/Linux/Ver");
  exit(0);
}


include("version_func.inc");

avastVer = get_kb_item("Avast!/AV/Linux/Ver");
if(avastVer == NULL){
  exit(0);
}

# Check for avast! Linux Home Edition version <= 1.0.8-2 (1.0.8)
if(version_is_less_equal(version:avastVer, test_version:"1.0.8")){
  security_warning(0);
}
