###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_arcavir_av_prdts_priv_esc_vuln.nasl 2570 2009-06-01 20:27:29Z june $
#
# ArcaVir AntiVirus Products Privilege Escalation Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800720);
  script_version("$Revision: 1.0 $");
  script_bugtraq_id(35100);
  script_cve_id("CVE-2009-1824");
  script_name("ArcaVir AntiVirus Products Privilege Escalation Vulnerability");
  desc = "

  Overview: This host is running ArcaVir AntiVirus Products and is prone to Privilege
  Escalation Vulnerability.

  Vulnerability Insight:
  This flaw is due to vulnerability in ps_drv.sys driver, which allows any users
  to open the device '\\Device\\ps_drv' and issue IOCTLs with a buffering mode of
  METHOD_NEITHER.

  Impact:
  Successful exploitation will let the attacker pass kernel addresses as the
  arguments to the driver and overwrite an arbitrary address in the kernel space
  through a specially crafted IOCTL.

  Impact level: System

  Affected Software/OS:
  ArcaBit 2009 Home Protection prior to 9.4.3204.9
  ArcaVir 2009 System Protection prior to 9.4.3203.9
  ArcaVir 2009 Internet Security prior to 9.4.3202.9
  ArcaBit ArcaVir 2009 Antivirus Protection prior to 9.4.3201.9

  Fix: Apply the security updates accordingly.
  http://www.arcabit.pl

  References:
  http://secunia.com/advisories/35260
  http://www.milw0rm.com/exploits/8782
  http://www.vupen.com/english/advisories/2009/1428
  http://ntinternals.org/ntiadv0814/ntiadv0814.html

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 5.6
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of ArcaVir AntiVirus Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Privilege escalation");
  script_dependencies("gb_arcavir_av_prdts_detect.nasl");
  script_require_keys("ArcaVir/AntiVirus/Ver");
  exit(0);
}


include("version_func.inc");

# ArcaVir AntiVirus Product version prior to 9.4.3201.9
arvaavVer = get_kb_item("ArcaVir/AntiVirus/Ver");
if(arvaavVer != NULL)
{
  if(version_is_less(version:arvaavVer, test_version:"9.4.3201.9")){
    security_hole(0);
  }
}
