###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_safari_mem_leak_dos_vuln.nasl 810 2009-01-13 15:28:53Z jan $
#
# Apple Safari WebKit Property Memory Leak Remote DoS Vulnerability
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800100);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5821");
  script_bugtraq_id(33080);
  script_name("Apple Safari WebKit Property Memory Leak Remote DoS Vulnerability");
  desc = "

  Overview : The host is installed with Apple Safari web browser and is prone
  to denial of service.

  Vulnerability Insight:
  The flaw is caused due to WebKit library which fails to validate the user
  input via a long ALINK attribute in a BODY element in an HTML document.

  Impact : Successful exploitation allow attackers to execute arbitrary code
  or can even crash the browser.

  Impact Level: Application

  Affected Software/OS:
  Apple Safari 3.2 and prior on Windows (Any).

  Fix: No solution or patch is available as on 13th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/support/downloads/

  References:
  http://packetstormsecurity.org/0812-exploits/safari_webkit_ml.txt
  http://jbrownsec.blogspot.com/2008/12/new-year-research-are-upon-us.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safVer = get_kb_item("AppleSafari/Version");
if(!safVer){
  exit(0);
}

# Grep for Apple Safari Version <= 3.2 (3.525.26.13)
if(version_is_less_equal(version:safVer, test_version:"3.525.26.13")){
  security_warning(0);
}
