###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_safari_js_uri_xss_vuln_sep09.nasl 4417 2009-09-02 18:35:26Z sep $
#
# Apple Safari 'javascript: URI' XSS Vulnerability - Sep09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800873);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3016");
  script_name("Apple Safari 'javascript: URI' XSS Vulnerability - Sep09");
  desc = "
  Overview: This host is installed with Apple Safari Web Browser and is prone
  to Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  Error occurs when application fails to sanitise the 'javascript:' and 'data:'
  URIs in Refresh headers in HTTP responses, which can be exploited via vectors
  related to injecting a Refresh header.

  Impact:
  Successful exploitation will let the attackers to conduct Cross-Site Scripting
  attacks in the victim's system.

  Impact Level: Application

  Affected Software/OS:
  Apple Safari version 4.0.3 on Windows.

  Fix: No solution or patch is available as on 02nd September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/support/downloads

  References:
  http://websecurity.com.ua/3386/

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safariVer = get_kb_item("AppleSafari/Version");
if(isnull(safariVer))
{
  exit(0);
}

# Check for Apple Safari Version < 4.0.3 (4.31.9.1)
if(version_is_equal(version:safariVer, test_version:"4.31.9.1")){
  security_warning(0);
}
