###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_safari_http_uri_dos_vuln_win.nasl 919 2009-02-02 09:40:26Z feb $
#
# Apple Safari Malformed URI Remote DoS Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800409);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0321");
  script_bugtraq_id(33481);
  script_name("Apple Safari Malformed URI Remote DoS Vulnerability (Win)");
  desc = "

  Overview: This host is installed with Apple Safari web browser and is prone
  to denial of service vulnerability.

  Vulnerability Insight:
  Malformed HTTP domain name can cause the safari web browser to a infinite
  loop which leads to memory violation when it tries to resolve the domain,
  or when it tries to write a section that contains unknown data.

  Impact:
  Browser crash (application termination) could be the result when attacker
  executes arbitrary codes.

  Impact Level: Application

  Affected Software/OS:
  Apple Safari 3.2.1 and prior on Windows (Any).

  Fix: No solution/patch is available as on 02nd February, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,  http://www.apple.com/support/downloads

  References:
  http://lostmon.blogspot.com/2009/01/safari-for-windows-321-remote-http-uri.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl",
                      "secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safVer = get_kb_item("AppleSafari/Version");
if(!safVer){
  exit(0);
}

# Grep for Apple Safari Version <= 3.2.1 (3.525.27.1)
if(version_is_less_equal(version:safVer, test_version:"3.525.27.1")){
  security_warning(0);
}
