###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_itunes_mult_vuln_mar09.nasl 959 2009-03-17 17:25:12Z mar $
#
# Apple iTunes Multiple Vulnerabilities
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800543);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-0143", "CVE-2009-0016");
  script_bugtraq_id(34094);
  script_name("Apple iTunes Multiple Vulnerabilities");
  desc = "

  Overview: This host has Apple iTunes installed, which is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  - the origin of an authentication request is not properly informed to the
    user.
  - an error is generated while processing a Digital Audio Access Protocol
    (DAAP) message containing specially crafted Content-Length parameter in
    the header of a DAAP message.

  Impact:
  This issue may be exploited to gain the user's itune credentials when
  subscribing to a malicious podcast and to cause denial of service.

  Impact Level: Application

  Affected Software/OS:
  Apple iTunes version prior to 8.1.0.51 on Windows.

  Fix: Upgrade to iTunes Version 8.1
  http://www.apple.com/itunes/download

  References:
  http://support.apple.com/kb/HT3487
  http://secunia.com/advisories/34254

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Apple iTunes");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_apple_itunes_detection_win_900123.nasl");
  script_require_keys("iTunes/Win/Ver");
  exit(0);
}


include("version_func.inc");

ver = get_kb_item("iTunes/Win/Ver");
if(!ver){
  exit(0);
}
if(version_is_less(version:ver, test_version:"8.1.0.51")){
 security_hole(0);
}
