##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_tomcat_detect.nasl 864 2009-03-12 18:57:24Z mar $
#
# Apache Tomcat Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800371);
  script_version("Revision: 1.0 ");
  script_name("Apache Tomcat Version Detection");
  desc = "

  Overview: This script detects the installed version of Apache Tomcat
  and saves the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set the KB for the Version of Apache Tomcat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:8080);
if(!port){
  port = 8080;
}

if(!get_port_state(port)){
  exit(0);
}

sndReq = http_get(item:string("/index.jsp \r\n"), port:port);
rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
if(rcvRes == NULL)
{
  sndReq = http_get(item:string("/RELEASE-NOTES.txt \r\n"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }
}

tomcatVer = eregmatch(pattern:"Apache Tomcat( Version |\/)([0-9.]+)",
                      string:rcvRes);
if("Apache Tomcat" >< tomcatVer[0] && tomcatVer[2] != NULL)
{
  set_kb_item(name:"www/" + port + "/ApacheTomcat", value:tomcatVer[2]);
}
