###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_struts_detect.nasl 1629 2009-04-22 19:20:29Z apr $
#
# Apache Struts Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800276);
  script_version("$Revision: 1.0 $");
  script_name("Apache Struts Version Detection");
  desc = "

  Overview: The script detects the version of Apache Struts and sets the
  result in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Apache Struts");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 8080);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

asPort = get_http_port(default:8080);
if(!asPort){
  asPort = 8080;
}

foreach dir (make_list("/", "/struts", cgi_dirs()))
{
  sndReq = string("GET " + dir + "/docs/index.html \r\n",
                  "Host: ", get_host_name(), "\r\n\r\n");
  rcvRes = http_keepalive_send_recv(port:asPort, data:sndReq);

  if("Struts" >< rcvRes)
  {
    core = string("GET ", dir + "/docs/WW/cwiki.apache.org/WW/home.html \r\n",
                  "Host: ", get_host_name(), "\r\n\r\n");
    buf = http_send_recv(port:asPort, data:core);

    if("Getting Started" >< buf && "Home" >< buf && "Distributions" >< buf){
      strutsVer = eregmatch(pattern:"Release Notes ([0-9]\.[0-9.]+)", string:buf);
    }

    if(strutsVer[1] == NULL)
    {
      guide = string("GET ", dir + "/docs/WW/cwiki.apache.org/WW/guides.html \r\n",
                     "Host: ", get_host_name(), "\r\n\r\n");
      buf = http_send_recv(port:asPort, data:guide);

      if("Migration Guide" >< buf && "Core Developers Guide" >< buf && "Release Notes" >< buf){
        strutsVer = eregmatch(pattern:"Release Notes ([0-9]\.[0-9.]+)", string:buf);
      }
    }

    if(strutsVer[1] != NULL){
      set_kb_item(name:"www/" + asPort + "/Apache/Struts", value:strutsVer[1] + " under " + dir);
    }
  }
}
