##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_apr_detect.nasl 3847 2009-08-14 15:30:37Z aug $
#
# Apache APR Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800680);
  script_version("$Revision: 1.0 $");
  script_name("Apache APR Version Detection");
  desc = "

  Overview : This script detects the installed version of Apache APR
  and sets the result in KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set Version of Apache APR in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

apr_sock = ssh_login_or_reuse_connection();
if(!apr_sock){
  exit(0);
}

foreach path (make_list("apr-config" ,"apr-1-config"))
{
  getPath = find_bin(prog_name:path, sock:apr_sock);

  foreach binaryFile (getPath)
  {
    aprVer = get_bin_version(full_prog_name:chomp(binaryFile), sock:apr_sock,
                             version_argv:"--version", ver_pattern:"[0-9.]+");

    if(aprVer[0] != NULL){
      set_kb_item(name:"Apache/APR/Ver", value:aprVer[0]);
    }
  }
}
ssh_close_connection();
