###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_38494.nasl 6897 2010-03-04 11:28:05Z mime $
#
# Apache Multiple Security Vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100514);
 script_bugtraq_id(38494,38491);
 script_cve_id("CVE-2010-0425","CVE-2010-0434","CVE-2010-0408");
 script_version ("1.0-$Revision: 6897 $");

 script_name("Apache Multiple Security Vulnerabilities");

desc = "Overview:
Apache is prone to multiple vulnerabilities.

These issues may lead to information disclosure or other attacks.

Apache versions prior to 2.2.15-dev are affected.

Solution:
These issues have been addressed in Apache 2.2.15-dev. Apache 2.2.15
including fixes will become available in the future as well. Please
see the references for more information.

References:
http://www.securityfocus.com/bid/38494
http://httpd.apache.org/security/vulnerabilities_22.html
http://httpd.apache.org/
https://issues.apache.org/bugzilla/show_bug.cgi?id=48359
http://svn.apache.org/viewvc?view=revision&revision=917870

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if installed Apache version is <= 2.2.14");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("secpod_apache_detect.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

httpdPort = get_http_port(default:80);
if(!httpdPort){
  exit(0);
}

version = get_kb_item("www/" + httpdPort + "/Apache");

if(version != NULL){
  if(version_in_range(version:version, test_version: "2.2",test_version2:"2.2.14")){
    security_warning(port: httpdPort);
    exit(0);
  }
}

exit(0);
