###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ajaxportal_file_inc_vuln.nasl 3189 2009-07-02 14:13:17Z jul $
#
# AjaxPortal 'di.php' File Inclusion Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800817);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2262");
  script_name("AjaxPortal 'di.php' File Inclusion Vulnerability");
  desc = "

  Overview: The host is running AjaxPortal and is prone to File Inclusion
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in the 'pathtoserverdata' parameter in
  install/di.php and it can exploited to cause PHP remote file inclusion.

  Impact:
  Successful exploitation will let the remote attacker to execute arbitrary
  PHP code via a URL in the pathtoserverdata parameter.

  Impact Level: Application

  Affected Software/OS:
  MyioSoft, AjaxPortal version 3.0

  Fix: No solution or patch is available as on 02nd July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://myiosoft.com

  References:
  http://www.securityfocus.com/archive/1/archive/1/504618/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of AjaxPortal");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_ajaxportal_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

ajaxPort = get_http_port(default:80);
if(!ajaxPort){
  exit(0);
}

foreach dir (make_list ("/", "/ajaxportal", "/portal", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/install/index.php", port:ajaxPort);
  rcvRes = http_send_recv(data:sndReq, port:ajaxPort);
  if(rcvRes =~ "MyioSoft EasyInstaller" &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    ajaxVer = get_kb_item("www/" + ajaxPort + "/AjaxPortal");
    ajaxVer = eregmatch(pattern:"^(.+) under (/.*)$", string:ajaxVer);
    if(ajaxVer[1] != NULL)
    {
      if(version_is_equal(version:ajaxVer[1], test_version:"3.0"))
      {
         security_warning(ajaxPort);
         exit(0);
      }
    }
  }
}
