###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ajaxportal_detect.nasl 3189 2009-07-01 13:48:24Z jul $
#
# AjaxPortal Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800816);
  script_version("Revision: 1.0");
  script_name("AjaxPortal Version Detection");
  desc = "

  Overview: This script detects the installed version of AjaxPortal and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set Version of AjaxPortal in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

ajaxPort = get_http_port(default:80);
if(!ajaxPort){
  ajaxPort = 80;
}

if(!get_port_state(ajaxPort)){
  exit(0);
}

foreach dir (make_list ("/", "/ajaxportal", "/portal", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/index.php", port:ajaxPort);
  rcvRes = http_send_recv(port:ajaxPort, data:sndReq);

  if(rcvRes =~ "<title>Ajax Portal-[Help|Myio] | Welcome  </title>" &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    ajaxVer = eregmatch(pattern:"Ajax Portal ([0-9]\.[0-9]+)", string:rcvRes);
    if(ajaxVer[1] != NULL)
    {
      set_kb_item(name:"www/" + ajaxPort + "/AjaxPortal",
                  value:ajaxVer[1] + " under " + dir);
    }
  }
}
