###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_aimp_id3_tag_bof_vuln.nasl 2743 2009-07-06 14:52:29Z jul $
#
# AIMP ID3 Tag Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Updated to CVE-2009-3170
# - By Nikita MR <rnikita@secpod.com> On 2009-09-15 #4729
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800591);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2009-1944", "CVE-2009-3170");
  script_name("AIMP ID3 Tag Buffer Overflow Vulnerability");
  desc = "
  Overview: This host has AIMP2 player installed and is prone to Buffer Overflow
  vulnerability.

  Vulnerability Insight:
  - A boundary check error exists while processing MP3 files with overly long
    ID3 tag.
  - Stack-based buffer overflow occurs when application fails to handle long
    File1 argument in a '.pls' or '.m3u' playlist file.

  Impact:
  Successful exploitation will allow remote attackes to exploit arbitrary
  code in the context of the affected application.

  Impact level: Application

  Affected Software/OS:
  AIMP2 version 2.5.1.330 and prior.

  Fix: No solution or patch is available as on 15th September, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.aimp.ru/index.php?newlang=english

  References:
  http://secunia.com/advisories/35295/
  http://www.milw0rm.com/exploits/9561
  http://www.milw0rm.com/exploits/8837
  http://xforce.iss.net/xforce/xfdb/50875
  http://www.vupen.com/english/advisories/2009/2530

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of AIMP2");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_aimp_detect.nasl");
  script_require_keys("AIMP/Ver");
  exit(0);
}


include("version_func.inc");

aimpVer = get_kb_item("AIMP/Ver");

if(aimpVer != NULL)
{
  # Grep for AIMP2 Player 2.5.1.330 and prior
  if(version_is_less_equal(version:aimpVer, test_version:"2.5.1.330")){
    security_hole(0);
  }
}
