###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_aimp_detect.nasl 2734 2009-07-06 13:55:05Z jul $
#
# AIMP Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Modified the file string.
# - By Nikita MR <rnikita@secpod.com> On 2009-09-15 #4729
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800590);
  script_version("$Revision: 1.1 $");
  script_name("AIMP Version Detection");
  desc = "
  Overview: This script detects the installed version of AIMP player and sets
  the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of AIMP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion"))
{
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\AIMP2";
appName = registry_get_sz(key:key, item:"DisplayName");

if("AIMP2" >< appName)
{
  aimpPath = registry_get_sz(key:key + item, item:"UninstallString");

  if(aimpPath != NULL)
  {
    share = ereg_replace(pattern:"([A-Z]):.*",replace:"\1$",string:aimpPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)",replace:"\1", string:aimpPath -
                        "\UnInstall.exe" - "Uninstall.exe" + "\AIMP2.exe");
    aimpVer = GetVer(share:share, file:file);

    if(aimpVer != NULL){
      set_kb_item(name:"AIMP/Ver", value:aimpVer);
    }
  }
}
