###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_aflog_cookie_auth_bypass_vuln.nasl 409 2008-11-10 10:20:11Z nov $
#
# aflog Cookie-Based Authentication Bypass Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800304);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4784");
  script_bugtraq_id(31894);
  script_name("aflog Cookie-Based Authentication Bypass Vulnerability");
  desc = "

  Overview: This host is running aflog and is prone to cookie-based authentication
  bypass vulnerability.

  Vulnerability Insight:
  The flaw is caused due to inadequacy in verifying user-supplied input used
  for cookie-based authentication by setting the aflog_auth_a cookie to
  'A' or 'O' in edit_delete.php, edit_cat.php, edit_lock.php,
  and edit_form.php.

  Impact:
  Exploitation will allow an attacker to gain administrative access and bypass
  authentication.

  Impact Level: System

  Affected Software/OS:
  aflog versions 1.01 and prior on all running platform

  Fix: No solution/patch is available as on 10th November, 2008. Information
  regarding this issue will updated once the solution details are available.
  For updates refer, http://e107.org/edownload.php

  References:
  http://www.milw0rm.com/exploits/6818
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-4784

  CVSS Score:
    CVSS Base Score     : 6.4 (AV:N/AC:L/Au:NR/C:P/I:P/A:N)
    CVSS Temporal Score : 5.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of aflog");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
if(!port){
  exit(0);
}

foreach path (make_list("/aflog", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/Readme.txt"), port:port);
  rcvRes = http_keepalive_send_recv(port:port, data:sndReq);
  if(rcvRes == NULL){
    exit(0);
  }

  if(egrep(pattern:"Aflog v1.01", string:rcvRes) &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    security_warning(port);
    exit(0);
  }
}
