###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_robohelp_server_detect.nasl 4515 2009-09-08 13:37:24Z sep $
#
# Adobe RoboHelp Server Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801102);
  script_version("$Revision: 1.0 $");
  script_name("Adobe RoboHelp Server Version Detection");
  desc = "
  Overview: This script detects the installed version of Adobe RoboHelp Server
  and sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set KB for the Version of Adobe RoboHelp Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80, 8080);
  exit(0);
}


include("http_func.inc");

robohelpPort = get_http_port(default:8080);
if(!robohelpPort){
  robohelpPort = 8080;
}

if(!get_port_state(robohelpPort))
{
  exit(0);
}

foreach dir (make_list("/robohelp", "/", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/admin/login.jsp", port:robohelpPort);
  rcvRes = http_send_recv(port:robohelpPort, data:sndReq);

  if("RoboHelp Server Login" >< rcvRes )
  {
    robohelpVer = eregmatch(pattern:"Version=([0-9.]+)", string:rcvRes);

    if(robohelpVer[1] != NULL)
    {
      set_kb_item(name:"www/" + robohelpPort + "/RoboHelpServer",
                  value:robohelpVer[1] + " under " + dir);
    }
  }
}
