###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_flash_player_remote_code_exec_vuln_winxp.nasl 6943 2010-01-13 15:06:02Z jan $
#
# Adobe Flash Player Remote Code Execution Vulnerability (WinXP)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Updated By:
# Antu Sanadi <santu@secpod.com> on 2010-01-22 #6943
# updated the CVE's and Vulnerability Insight
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800420);
  script_version("$Revision: 6582 $: 1.1");
  script_cve_id("CVE-2010-0378", "CVE-2010-0379");
  script_name("Adobe Flash Player Remote Code Execution Vulnerability (WinXP)");
  desc = "
  Overview: This host has Adobe Flash Player installed and is prone to remote
  code execution vulnerability.

  Vulnerability Insight:
  The flaw is caused due to a use-after-free error in the bundled version of Flash
  Player when unloading Flash objects while these are still being accessed using
  script code.

  Impact:
  Successful exploitation could allow remote attackers to crash an affected
  system or execute arbitrary code by tricking a user into visiting a specially
  crafted web page.

  Impact Level: System.

  Affected Software/OS:
  Adobe Flash Player 6.x on Windows XP.

  Fix: Upgrade to Adobe Flash Player 10.0.42.34,
  For Updates Refer, http://www.adobe.com/downloads/

  References:
  http://secunia.com/advisories/27105
  http://secunia.com/secunia_research/2007-77/
  http://securitytracker.com/alerts/2010/Jan/1023435.html
  http://www.microsoft.com/technet/security/advisory/979267.mspx

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 6.9
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Flash Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Windows");
  script_dependencies("gb_adobe_flash_player_detect_win.nasl");
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");

if(hotfix_check_sp(xp:4) <= 0){
  exit(0);
}

adobeVer = get_kb_item("AdobeFlashPlayer/Win/Ver");
# Grep for versions 6 Series
if((adobeVer) && (adobeVer =~ "^6\.")){
   security_hole(0);
}
