###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_flash_player_detect_win.nasl 320 2008-10-16 17:19:29Z oct $
#
# Adobe Flash Player Version Detection (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800029);
  script_version("$Revision: 1.0 $");
  script_name("Adobe Flash Player Version Detection (Win)");
  desc = "
  Overview: This script detects the version of Adobe Product(s) and sets the
  result the KB.

  Risk factor : Informational";

  script_description(desc);
  script_summary("Set KB for the version of Adobe Flash Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Set KB for Adobe Flash Player, Adobe Flash CS Professional and Adobe Flex
playerFlag = 0; airFlag = 0; csFlag = 0; flexFlag = 0;
key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  adobeName = registry_get_sz(key:key + item, item:"DisplayName");

  if("Adobe AIR" >< adobeName && airFlag == 0)
  {
    airVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(airVer != NULL)
    {
      set_kb_item(name:"Adobe/Air/Win/Ver", value:airVer);
      airFlag = 1;
    }
  }

  else if("Adobe Flash CS" >< adobeName && csFlag == 0)
  {
    fcsVer = eregmatch(pattern:"Flash (CS[0-9])", string:adobeName);
    if(fcsVer[1] != NULL)
    {
      set_kb_item(name:"Adobe/FlashCS/Win/Ver", value:fcsVer[1]);
      csFlag = 1;
    }
  }

  else if("Adobe Flash Player" >< adobeName && playerFlag == 0)
  {
    playerVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(playerVer != NULL)
    {
      set_kb_item(name:"AdobeFlashPlayer/Win/Ver", value:playerVer);
      playerFlag = 1;
    }
  }

  else if("Adobe Flex" >< adobeName && flexFlag == 0)
  {
    flexVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(flexVer != NULL)
    {
      set_kb_item(name:"Adobe/Flex/Win/Ver", value:flexVer);
      flexFlag = 1;
    }
  }
}
