###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_acrobat_pdf_vuln_win.nasl 604 2008-12-10 09:32:12Z dec $
#
# Adobe Acrobat 9 PDF Document Encryption Weakness Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800078);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5331");
  script_bugtraq_id(32610);
  script_name("Adobe Acrobat 9 PDF Document Encryption Weakness Vulnerability (Win)");
  desc = "

  Overview: This host has Adobe Acrobat installed and is prone to encryption
  weakness vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the way it handles encryption standards.

  Impact:
  Successful exploitation could allow attackers to steal or guess document's
  password via a brute force attacks.

  Impact Level: Application

  Affected Software/OS:
  Adobe Acrobat version 9.0 on Windows.

  Fix: No solution or patch is available as on 09th December, 2008. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.adobe.com/products/

  References:
  http://blogs.adobe.com/security/2008/12/acrobat_9_and_password_encrypt.html

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Adobe Acrobat");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Windows");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Adobe")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  adobeName = registry_get_sz(item:"DisplayName", key:key +item);
  if("Adobe Acrobat" >< adobeName)
  {
    adobeVer = registry_get_sz(item:"DisplayVersion", key:key + item);
    if(!adobeVer){
      exit(0);
    }

    if(adobeVer =~ "^9\.0(\.0)?$"){
      security_hole(0);
    }
    exit(0);
  }
}
