###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_7zip_archive_handling_vuln_win.nasl 1303 2009-04-01 21:20:29Z apr $
#
# 7-Zip Unspecified Archive Handling Vulnerability (Win)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800261);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6536");
  script_bugtraq_id(28285);
  script_name("7-Zip Unspecified Archive Handling Vulnerability (Win)");
  desc = "

  Overview: This host is installed with 7zip and is prone to Unspecified
  vulnerability.

  Vulnerability Insight:
  This flaw occurs due to memory corruption while handling malformed archives.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code in the
  affected system and cause denial of service.

  Affected Software/OS:
  7zip version prior to 4.57 on Windows.

  Fix:
  Upgrade to 7zip version 4.57
  http://www.7-zip.org

  References:
  http://secunia.com/advisories/29434
  http://www.vupen.com/english/advisories/2008/0914/references
  http://www.cert.fi/haavoittuvuudet/joint-advisory-archive-formats.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of 7zip");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_7zip_detect_win.nasl");
  script_require_keys("7zip/Win/Ver");
  exit(0);
}

include("version_func.inc");

version = get_kb_item("7zip/Win/Ver");
if(!version){
  exit(0);
}

# Grep for 7zip version prior to 4.57
if(version_is_less(version:version, test_version:"4.57")){
  security_hole(0);
}
