###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_2532gigs_detect.nasl 3826 2009-08-14 15:37:24Z aug $
#
# 2532|Gigs Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800681);
  script_version("$Revision: 1.0 $");
  script_name("2532|Gigs Version Detection");
  desc = "

  Overview: This script detects the installed version of 2532|Gigs and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set Version of 2532|Gigs in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

gigsPort = get_http_port(default:80);

if(!gigsPort){
  gigsPort = 80;
}

if(!get_port_state(gigsPort)){
  exit(0);
}

foreach dir (make_list("/2532Gigs", "/Gigs", "/bands", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/index.php", port:gigsPort);
  rcvRes = http_send_recv(port:gigsPort, data:sndReq);

  if("Powered by 2532|Gigs" >< rcvRes)
  {
    gigsVer = eregmatch(pattern:"2532\|Gigs v([0-9]+\.[0-9]\.[0-9])",
                        string:rcvRes);

    if(gigsVer[1] != NULL)
    {
      set_kb_item(name:"www/" + gigsPort + "/2532|Gigs",
                  value:gigsVer[1] + " under " + dir);
    }
  }
}
