# OpenVAS Vulnerability Test
# $Id$
# Description: Gather installed packages/rpms/etc for local security checks
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
# Tim Brown <timb@openvas.org>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Copyright (c) 2008 Tim Brown
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

if(description)
{
 script_id(50282);
 script_version("1.2-$Revision: 6434 $");

 name = "Determine OS and list of installed packages via SSH login";
 script_name(name);

 desc = "
This script will, if given a userid/password or
key to the remote system, login to that system,
determine the OS it is running, and for supported
systems, extract the list of installed packages/rpms.

Risk factor : None";

 script_description(desc);

 summary = "Determine OS and list of installed packages via SSH login";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com & Tim Brown");
 script_family("General");
 script_dependencies("find_service.nes", "ssh_authorization.nasl");
 exit(0);
}

#
# The script code starts here
#
cmdline = 0;
include("ssh_func.inc");

port = get_kb_item("Services/ssh");
if(!port) {
    port = 22;
}
sock = ssh_login_or_reuse_connection();
if(!sock) {
    # Send "error" as set by ssh_funcs.
    log_message(port:port, data:get_ssh_error());
    exit(0);
}

# First command: Grab uname -a of the remote system
uname = ssh_cmd(socket:sock, cmd:"uname -a");
set_kb_item(name: "ssh/login/uname", value:uname);

# GNU/Linux platforms:

# Ok...let's first check if this is a RedHat/Fedora Core/Mandrake release
rls = ssh_cmd(socket:sock, cmd:"cat /etc/redhat-release");
if("Red Hat Linux release 7.3" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "RH7.3");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Red Hat Linux release 8.0 (Psyche)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "RH8.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Red Hat Linux release 9 (Shrike)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "RH9");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora Core release 1 (Yarrow)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora Core release 2 (Tettnang)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora Core release 3 (Heidelberg)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC3");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora Core release 4 (Stentz)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC4");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora Core release 5 (Bordeaux)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC5");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora Core release 6 (Zod)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC6");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora release 7 (Moonshine)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC7");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora release 8 (Werewolf)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC8");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora release 9 (Sulphur)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC9");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora release 10 (Cambridge)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC10");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora release 11 (Leonidas)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC11");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Fedora release 12 (Constantine)" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "FC12");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}

# Red Hat Enterprise Linux ES release 2.1 (Panama)
# Red Hat Enterprise Linux AS release 3 (Taroon Update 1)
# Red Hat Enterprise Linux AS release 3 (Taroon Update 2)
# Red Hat Enterprise Linux AS release 3 (Taroon Update 3)
# Red Hat Enterprise Linux Desktop release 3.90

if(egrep(pattern:"Red Hat Enterprise.*release 2\.1", string:rls)) {
    set_kb_item(name: "ssh/login/release", value: "RHENT_2.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE}~%{SIGGPG:pgpsig};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if(egrep(pattern:"Red Hat Enterprise.*release 3[ .]", string:rls)) {
    set_kb_item(name: "ssh/login/release", value: "RHENT_3");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE}~%{SIGGPG:pgpsig};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if(egrep(pattern:"Red Hat Enterprise.*release 4[ .]", string:rls)) {
    set_kb_item(name: "ssh/login/release", value: "RHENT_4");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE}~%{SIGGPG:pgpsig};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if(egrep(pattern:"Red Hat Enterprise.*release 5[ .]", string:rls)) {
    set_kb_item(name: "ssh/login/release", value: "RHENT_5");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE}~%{SIGGPG:pgpsig};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}

if("Mandriva Linux Enterprise Server release 5.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_mes5");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandriva Linux release 2010.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_2010.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandriva Linux release 2009.1" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_2009.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandriva Linux release 2009.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_2009.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandriva Linux release 2008.1" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_2008.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandriva Linux release 2008.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_2008.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandriva Linux release 2007.1" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_2007.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandriva Linux release 2007.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_2007.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandriva Linux release 2006.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_2006.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandrakelinux release 10.2" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_10.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandrakelinux release 10.1" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_10.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandrake Linux release 10.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_10.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandrake Linux release 9.2" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_9.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandrake Linux release 9.1" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_9.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandrake Linux release 8.1" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_8.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandrake Linux release 8.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_8.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Mandrake Linux release 7.2" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "MNDK_7.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}

# Ok...also using /etc/redhat-release is CentOS...let's try them now
# We'll stay with major release # checking unless we find out we need to do
# otherwise.
#CentOS release 4.0 (Final)
#CentOS release 4.1 (Final)
#CentOS release 3.4 (final)
if("CentOS release 5" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "CentOS5");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running CentOS release 5"));
    exit(0);
}
if("CentOS release 4" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "CentOS4");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running CentOS release 4"));
    exit(0);
}
if("CentOS release 3" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "CentOS3");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running CentOS release 3"));
    exit(0);
}
if("CentOS release 2" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "CentOS2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running CentOS release 2"));
    exit(0);
}

# Hmmm...is it Ubuntu?
rls = ssh_cmd(socket:sock, cmd:"cat /etc/lsb-release");
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=4.10"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU4.1");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 4.10"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=5.04"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU5.04");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 5.04"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=5.10"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU5.10");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 5.10"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=6.06"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU6.06 LTS");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 6.06"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=6.10"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU6.10");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 6.10"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=7.04"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU7.04");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 7.04"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=7.10"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU7.10");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 7.10"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=8.04"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU8.04 LTS");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 8.04 LTS"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=8.10"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU8.10");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 8.10"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=9.04"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU9.04");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 9.04"));
    exit(0);
}
if("DISTRIB_ID=Ubuntu"><rls && "DISTRIB_RELEASE=9.10"><rls) {
    set_kb_item(name: "ssh/login/release", value: "UBUNTU9.10");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Ubuntu 9.10"));
    exit(0);
}

# How about Conectiva Linux?
rls = ssh_cmd(socket:sock, cmd:"cat /etc/conectiva-release");
if("Conectiva Linux 9" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "CL9");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Conectiva Linux 9"));
    exit(0);
}
if("Conectiva Linux 10" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "CL10");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Conectiva Linux 10"));
    exit(0);
}

# How about Turbolinux?
# Turbolinux signatures:
# release 6.0 WorkStation (Shiga)       -- Unsupported
# TurboLinux release 6.1 Server (Naha)	-- Unsupported
# Turbolinux Server 6.5 (Jupiter)       -- Unsupported
# Turbolinux Server 7.0 (Esprit)
# Turbolinux Workstation 7.0 (Monza)
# Turbolinux Server 8.0 (Viper)
# Turbolinux Workstation 8.0 (SilverStone)
# Turbolinux Server 10.0 (Celica)
# Turbolinux Desktop 10.0 (Suzuka)
# -- Need:
#- Turbolinux Appliance Server 1.0 Hosting Edition
#- Turbolinux Appliance Server 1.0 Workgroup Edition
#- Turbolinux Home
#- Turbolinux 10 F...

rls = ssh_cmd(socket:sock, cmd:"cat /etc/turbolinux-release");
if("Turbolinux Server 7.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "TLS7");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Turbolinux Workstation 7.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "TLWS7");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Turbolinux Server 8.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "TLS8");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Turbolinux Workstation 8.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "TLWS8");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Turbolinux Desktop 10.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "TLDT10");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Turbolinux Server 10.0" >< rls) {
    set_kb_item(name: "ssh/login/release", value: "TLS10");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running ", rls));
    exit(0);
}
if("Turbolinux">< rls) {
    security_note(port:port, data:string("We have detected you are running a version of Turbolinux currently not supported by SecuritySpace.  Please report the following banner to SecuritySpace: ", rls));
    exit(0);
}

# Hmmm...is it Debian?
rls = ssh_cmd(socket:sock, cmd:"cat /etc/debian_version");
if("2.2"><rls) {
    set_kb_item(name: "ssh/login/release", value: "DEB2.2");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Debian 2.2 (Potato)"));
    exit(0);
}
if("3.0"><rls) {
    set_kb_item(name: "ssh/login/release", value: "DEB3.0");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Debian 3.0 (Woody)"));
    exit(0);
}
if("3.1"><rls) {
    set_kb_item(name: "ssh/login/release", value: "DEB3.1");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Debian 3.1 (Sarge)"));
    exit(0);
}
if("4.0"><rls) {
    set_kb_item(name: "ssh/login/release", value: "DEB4.0");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Debian 4.0 (Etch)"));
    exit(0);
}
if("5.0"><rls) {
    set_kb_item(name: "ssh/login/release", value: "DEB5.0");
    buf = ssh_cmd(socket:sock, cmd:"COLUMNS=200 dpkg -l");
    set_kb_item(name: "ssh/login/packages", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Debian 5.0 (Lenny)"));
    exit(0);
}


# How about Slackware?
rls = ssh_cmd(socket:sock, cmd:"cat /etc/slackware-version");
if("Slackware 12.0"><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLK12.0");
    buf = ssh_cmd(socket:sock, cmd:"ls /var/log/packages");
    set_kb_item(name: "ssh/login/slackpack", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Slackware 12.0"));
    exit(0);
}
if("Slackware 11.0"><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLK11.0");
    buf = ssh_cmd(socket:sock, cmd:"ls /var/log/packages");
    set_kb_item(name: "ssh/login/slackpack", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Slackware 11.0"));
    exit(0);
}
if("Slackware 10.2"><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLK10.2");
    buf = ssh_cmd(socket:sock, cmd:"ls /var/log/packages");
    set_kb_item(name: "ssh/login/slackpack", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Slackware 10.2"));
    exit(0);
}
if("Slackware 10.1"><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLK10.1");
    buf = ssh_cmd(socket:sock, cmd:"ls /var/log/packages");
    set_kb_item(name: "ssh/login/slackpack", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Slackware 10.1"));
    exit(0);
}
if("Slackware 10.0"><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLK10.0");
    buf = ssh_cmd(socket:sock, cmd:"ls /var/log/packages");
    set_kb_item(name: "ssh/login/slackpack", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Slackware 10.0"));
    exit(0);
}
if("Slackware 9.1"><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLK9.1");
    buf = ssh_cmd(socket:sock, cmd:"ls /var/log/packages");
    set_kb_item(name: "ssh/login/slackpack", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Slackware 9.1"));
    exit(0);
}
if("Slackware 9.0"><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLK9.0");
    buf = ssh_cmd(socket:sock, cmd:"ls /var/log/packages");
    set_kb_item(name: "ssh/login/slackpack", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Slackware 9.0"));
    exit(0);
}
if("Slackware 8.1"><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLK8.1");
    buf = ssh_cmd(socket:sock, cmd:"ls /var/log/packages");
    set_kb_item(name: "ssh/login/slackpack", value:buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Slackware 8.1"));
    exit(0);
}

# How about SuSe? and openSUSE?

rls = ssh_cmd(socket:sock, cmd:"cat /etc/SuSE-release");
if("SUSE Linux Enterprise Server 11 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLES11.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux Enterprise Server 11"));
    exit(0);
}
if("SUSE Linux Enterprise Server 10 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLES10.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux Enterprise Server 10"));
    exit(0);
}
if("SUSE LINUX Enterprise Server 9 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SLES9.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux Enterprise Server 9"));
    exit(0);
}
if("openSUSE 11.2 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "openSUSE11.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running openSUSE 11.2"));
    exit(0);
}
if("openSUSE 11.1 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "openSUSE11.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running openSUSE 11.1"));
    exit(0);
}
if("openSUSE 11.0 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "openSUSE11.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running openSUSE 11.0"));
    exit(0);
}
if("openSUSE 10.3 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "openSUSE10.3");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running openSUSE 10.3"));
    exit(0);
}

if("openSUSE 10.2 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "openSUSE10.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running openSUSE 10.2"));
    exit(0);
}

if("openSUSE 10.1 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "openSUSE10.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running openSUSE 10.1"));
    exit(0);
}

if("SUSE LINUX 11 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE11");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 11"));
    exit(0);
}
if("SUSE LINUX 10.3 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE10.3");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 10.3"));
    exit(0);
}
if("SUSE LINUX 10.2 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE10.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 10.2"));
    exit(0);
}
if("SUSE LINUX 10.1 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE10.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 10.1"));
    exit(0);
}
if("SuSE Linux 9.3 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE9.3");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 9.3"));
    exit(0);
}
if("SuSE Linux 9.2 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE9.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 9.2"));
    exit(0);
}
if("SuSE Linux 9.1 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE9.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 9.1"));
    exit(0);
}
if("SuSE Linux 9.0 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE9.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 9.0"));
    exit(0);
}
if("SuSE Linux 8.2 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE8.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 8.2"));
    exit(0);
}
if("SuSE Linux 8.1 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE8.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 8.1"));
    exit(0);
}
if("SuSE Linux 8.0 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE8.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 8.0"));
    exit(0);
}
if("SuSE Linux 7.3 "><rls) {
    set_kb_item(name: "ssh/login/release", value: "SUSE7.3");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running SuSE Linux 7.3"));
    exit(0);
}


# How about Trustix?
rls = ssh_cmd(socket:sock, cmd:"cat /etc/release");
rls2 = ssh_cmd(socket:sock, cmd:"cat /etc/trustix-release");
if("Trustix Secure Linux release 3.0.5"><rls ||
       "Trustix Secure Linux release 3.0.5"><rls2) {
    set_kb_item(name: "ssh/login/release", value: "TSL3.0.5");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Trustix 3.0.5"));
    exit(0);
}
if("Trustix Secure Linux release 3.0"><rls ||
       "Trustix Secure Linux release 3.0"><rls2) {
    set_kb_item(name: "ssh/login/release", value: "TSL3.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Trustix 3.0"));
    exit(0);
}
if("Trustix Secure Linux release 2.2"><rls ||
       "Trustix Secure Linux release 2.2"><rls2) {
    set_kb_item(name: "ssh/login/release", value: "TSL2.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Trustix 2.2"));
    exit(0);
}
if("Trustix Secure Linux release 2.1"><rls ||
       "Trustix Secure Linux release 2.1"><rls2) {
    set_kb_item(name: "ssh/login/release", value: "TSL2.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Trustix 2.1"));
    exit(0);
}
if("Trustix Secure Linux release 2.0"><rls ||
       "Trustix Secure Linux release 2.0"><rls2) {
    set_kb_item(name: "ssh/login/release", value: "TSL2.0");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Trustix 2.0"));
    exit(0);
}
if("Trustix Secure Linux release 1.5"><rls ||
       "Trustix Secure Linux release 1.5"><rls2) {
    set_kb_item(name: "ssh/login/release", value: "TSL1.5");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Trustix 1.5"));
    exit(0);
}
if("Trustix Secure Linux release 1.2"><rls ||
       "Trustix Secure Linux release 1.2"><rls2) {
    set_kb_item(name: "ssh/login/release", value: "TSL1.2");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Trustix 1.2"));
    exit(0);
}
if("Trustix Secure Linux release 1.1"><rls ||
       "Trustix Secure Linux release 1.1"><rls2) {
    set_kb_item(name: "ssh/login/release", value: "TSL1.1");
    buf = ssh_cmd(socket:sock, cmd:"/bin/rpm -qa --qf '%{NAME}~%{VERSION}~%{RELEASE};\n'");
    set_kb_item(name: "ssh/login/rpms", value: ";" + buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Trustix 1.1"));
    exit(0);
}
# Missing Trustix e-2

# How about Gentoo? Note, just check that its ANY gentoo release, since the
# build # doesn't matter for purposes of checking package version numbers.
rls = ssh_cmd(socket:sock, cmd:"cat /etc/gentoo-release");
if("Gentoo"><rls) {
    set_kb_item(name: "ssh/login/release", value: "GENTOO");
    set_kb_item(name: "ssh/login/gentoo", value: "GENTOO");
    buf = ssh_cmd(socket:sock, cmd:'find /var/db/pkg -mindepth 2 -maxdepth 2 -printf "%P\\n"');
    set_kb_item(name: "ssh/login/pkg", value: buf);
    # Determine the list of maintained packages
    buf = ssh_cmd(socket:sock, cmd: "find /usr/portage/ -wholename '/usr/portage/*-*/*.ebuild' | sed 's,/usr/portage/\([^/]*\)/.*/\([^/]*\)\.ebuild$,\1/\2,'");
    if(strlen(buf)==0) { # Earlier find used 'path' in place of 'wholename'
	buf = ssh_cmd(socket:sock, cmd: "find /usr/portage/ -path '/usr/portage/*-*/*.ebuild' | sed 's,/usr/portage/\([^/]*\)/.*/\([^/]*\)\.ebuild$,\1/\2,'");
    }
    set_kb_item(name: "ssh/login/gentoo_maintained", value: buf);
    security_note(port:port, data:string("We are able to login and detect that you are running Gentoo"));
    exit(0);
}

# Non GNU/Linux platforms:


## HP-UX Operating System

if ("HP-UX" >< uname){
    rls = ssh_cmd(socket:sock, cmd:"uname -r");

    if("10.01"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX10.01");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 10.01"));
	exit(0);
    }
    if("10.10"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX10.10");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 10.10"));
	exit(0);
    }
    if("10.20"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX10.20");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 10.20"));
	exit(0);
    }
    if("10.24"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX10.24");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 10.24"));
	exit(0);
    }
    if("10.26"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX10.26");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 10.26"));
	exit(0);
    }
    if("11.00"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX11.00");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 11.00"));
	exit(0);
    }
    if("11.04"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX11.04");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 11.04"));
	exit(0);
    }
    if("11.11"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX11.11");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 11.11"));
	exit(0);
    }
    if("11.20"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX11.20");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 11.20"));
	exit(0);
    }
    if("11.22"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX11.22");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 11.22"));
	exit(0);
    }
    if("11.23"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX11.23");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 11.23"));
	exit(0);
    }
    if("11.31"><rls) {
	set_kb_item(name: "ssh/login/release", value: "HPUX11.31");
	buf = ssh_cmd(socket:sock, cmd:"swlist -l patch -a supersedes");
	set_kb_item(name: "ssh/login/hp_pkgsupersedes", value:buf);
	buf = ssh_cmd(socket:sock, cmd:"swlist -a revision -l fileset");
	set_kb_item(name: "ssh/login/hp_pkgrev", value:buf);
	security_note(port:port, data:string("We are able to login and detect that you are running HP-UX 11.31"));
	exit(0);
    }
}

#How about FreeBSD?  If the uname line begins with "FreeBSD ", we have a match
if(substr(uname, 0, 7)=="FreeBSD ") {
    version=eregmatch(pattern:"^[^ ]+ [^ ]+ ([^ ]+)+",string:uname);
    splitup = eregmatch(pattern:"([^-]+)-([^-]+)-p([0-9]+)", string:version[1]);
    found = 0;
    if(!isnull(splitup)) {
	release = splitup[1];
	patchlevel = splitup[3];
	found = 1;
    } else {
	splitup = eregmatch(pattern:"([^-]+)-RELEASE", string:version[1]);
	if(!isnull(splitup)) {
	    release = splitup[1];
	    patchlevel = "0";
	    found = 1;
	} else {
	    splitup=eregmatch(pattern:"([^-]+)-SECURITY",string:version[1]);
	    if(!isnull(splitup)) {
		release = splitup[1];
		security_note(port:port, data:string("We have detected you are running FreeBSD ", splitup[0], ". It also appears that you are using freebsd-update, a binary update tool for keeping your distribution up to date.  We will not be able to check your core distribution for vulnerabilities, but we will check your installed ports packages."));
		found = 2;
	    } else {
		security_note(port:port, data:string("You appear to be running FreeBSD, but we do not recognize the output format of uname: ", uname, ". Local security checks will NOT be run."));
	    }
	}
    }
    if(found==1) {
	set_kb_item(name: "ssh/login/freebsdrel", value: release);
	set_kb_item(name: "ssh/login/freebsdpatchlevel", value: patchlevel);
	security_note(port:port, data:string("We are able to login and detect that you are running FreeBSD ", release, " Patch level: ", patchlevel));
    }
    if(found==2) {
	set_kb_item(name: "ssh/login/freebsdrel", value: release);
	security_note(port:port, data:string("We are able to login and detect that you are running FreeBSD ", release, " Patch level: Unknown"));
    }
    if(found!=0) {
	buf = ssh_cmd(socket:sock, cmd:"pkg_info");
	set_kb_item(name: "ssh/login/freebsdpkg", value:buf);
    }
    exit(0);
}

# Whilst we're at it, lets check if it's Solaris
if (substr(uname, 0, 5) == "SunOS ") {
    osversion = ssh_cmd(socket:sock, cmd:"uname -r");
    set_kb_item(name: "ssh/login/solosversion", value:osversion);
    hardwaretype = ssh_cmd(socket:sock, cmd:"uname -p");
    set_kb_item(name: "ssh/login/solhardwaretype", value:hardwaretype);
    buf = ssh_cmd(socket:sock, cmd:"pkginfo");
    set_kb_item(name: "ssh/login/solpackages", value:buf);
    buf = ssh_cmd(socket:sock, cmd:"showrev -p");
    set_kb_item(name: "ssh/login/solpatches", value:buf);
    if (hardwaretype >< "sparc") {
        security_note(port:port, data:string("We are able to login and detect that you are running Solaris ", osversion, " Arch: SPARC"));
    } else {
        security_note(port:port, data:string("We are able to login and detect that you are running Solaris ", osversion, " Arch: x86"));
    }
    exit(0);
}

#maybe it's a real OS... like Mac OS X :)
if ("Darwin" >< uname)
{
    rls = ssh_cmd(socket:sock, cmd:"cat -v -t /System/Library/CoreServices/SystemVersion.plist | egrep '10' | tail -n 1 | sed s/'\^I<string>'// | sed s/'<\/string>'//");    
    if (eregmatch(string:rls, pattern:"10\.[0-9]+\.[0-9]+", icase:1) == TRUE) {
		rls = "Mac OS X "+rls;
    	set_kb_item(name: "ssh/login/release", value:rls);	
    	security_note(data:string("We are able to login and detect that you are running ", rls));
    	}
    exit(0);	
}

#{ "NetBSD",     "????????????????",         },
#{ "OpenBSD",    "????????????????",         },
#{ "WhiteBox",   "????????????????",         },
#{ "Linspire",   "????????????????",         },
#{ "Desktop BSD","????????????????",         },
#{ "PC-BSD",     "????????????????",         },
#{ "FreeSBIE",   "????????????????",         },
#{ "JDS",        "/etc/sun-release",         },
#{ "Yellow Dog", "/etc/yellowdog-release",   },

security_note(port: 0, data: strcat('System identifier unknown: "', uname, '"\nTherefore no local security checks applied (missing list of installed packages) though ssh login provided and works'));

exit(0);
