#
#ADV FreeBSD-SA-09:07.libc.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from ADV FreeBSD-SA-09:07.libc.asc
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63900);
 script_version ("$");
 name = "FreeBSD Security Advisory (FreeBSD-SA-09:07.libc.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-09:07.libc.asc

FreeBSD's C library (libc) contains code for creating and accessing
Berkeley DB 1.85 database files.  Such databases are used extensively
in FreeBSD; for example, the system password files (/etc/passwd and
/etc/master.passwd) are normally accessed via their database files
(/etc/pwd.db and /etc/spwd.db).

Some data structures used by the database interface code are not properly
initialized when allocated.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-09:07.libc.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-09:07.libc.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"7.1", patchlevel:"5")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"7.0", patchlevel:"12")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.4", patchlevel:"4")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.3", patchlevel:"10")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
