#
#ADV FreeBSD-SA-07:01.jail.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(57785);
 script_cve_id("CVE-2007-0166");
 script_version ("$");
 name = "FreeBSD Security Advisory (FreeBSD-SA-07:01.jail.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-07:01.jail.asc

The jail(2) system call allows a system administrator to lock a process
and all of its descendants inside an environment with a very limited
ability to affect the system outside that environment, even for
processes with superuser privileges.  It is an extension of, but
far more powerful than, the traditional UNIX chroot(2) system call.

The host's jail rc.d(8) script can be used to start and stop jails
automatically on system boot/shutdown.

In multiple situations the host's jail rc.d(8) script does not check if
a path inside the jail file system structure is a symbolic link before
using the path.  In particular this is the case when writing the
output from the jail start-up to /var/log/console.log and when
mounting and unmounting file systems inside the jail directory
structure.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-07:01.jail.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-07:01.jail.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"6.1", patchlevel:"12")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.0", patchlevel:"17")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"5.5", patchlevel:"10")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
