#
#ADV FreeBSD-SA-09:14.devfs.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from ADV FreeBSD-SA-09:14.devfs.asc
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65014);
 script_version ("$");
 script_name("FreeBSD Security Advisory (FreeBSD-SA-09:14.devfs.asc)");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-09:14.devfs.asc

The device file system (devfs) provides access to system devices, such as
storage devices and serial ports, via the file system namespace.

VFS is the Virtual File System, which abstracts file system operations in
the kernel from the actual underlying file system.

Due to the interaction between devfs and VFS, a race condition exists
where the kernel might dereference a NULL pointer.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-09:14.devfs.asc
Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Security Advisory (FreeBSD-SA-09:14.devfs.asc)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"7.2", patchlevel:"4")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"7.1", patchlevel:"8")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.4", patchlevel:"7")<0) {
    vuln = 1;
}
if(patchlevelcmp(rel:"6.3", patchlevel:"13")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
