#
#VID 61534682-b8f4-11da-8e62-000e0c33c2dc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56449);
 script_bugtraq_id(17169);
 script_cve_id("CVE-2006-0745");
 script_version ("$");
 name = "FreeBSD Ports: xorg-server";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: xorg-server

CVE-2006-0745
X.Org server (xorg-server) 1.0.0 and later, X11R6.9.0, and X11R7.0
inadvertently treats the address of the geteuid function as if it is
the return value of a call to geteuid, which allows local users to
bypass intended restrictions and (1) execute arbitrary code via the
-modulepath command line option or (2) overwrite arbitrary files via
-logfile.

Solution:
Update your system with the appropriate patches or
software upgrades.

https://bugs.freedesktop.org/show_bug.cgi?id=6213
http://www.vuxml.org/freebsd/61534682-b8f4-11da-8e62-000e0c33c2dc.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: xorg-server";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"xorg-server");
if(!isnull(bver) && revcomp(a:bver, b:"6.9.0")==0) {
    security_note(0, data:"Package xorg-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
