#
#VID 8338a20f-9573-11d8-9366-0020ed76ef5a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52474);
 script_cve_id("CVE-2004-0409");
 script_version ("$");
 name = "FreeBSD Ports: xchat2";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: xchat2

CVE-2004-0409
Stack-based buffer overflow in the Socks-5 proxy code for XChat 1.8.0
to 2.0.8, with socks5 traversal enabled, allows remote attackers to
execute arbitrary code.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://xchat.org/files/source/2.0/patches/xc208-fixsocks5.diff
http://marc.theaimsgroup.com/?l=xchat-announce&m=108114935507357
http://www.vuxml.org/freebsd/8338a20f-9573-11d8-9366-0020ed76ef5a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: xchat2";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"xchat2");
if(!isnull(bver) && revcomp(a:bver, b:"1.8")>=0 && revcomp(a:bver, b:"2.0.8_2")<0) {
    security_note(0, data:"Package xchat2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
