#
#VID e0b342a1-d2ae-11da-a672-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56657);
 script_cve_id("CVE-2005-4463");
 script_version ("$");
 name = "FreeBSD Ports: wordpress";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: wordpress

CVE-2005-4463
WordPress before 1.5.2 allows remote attackers to obtain sensitive
information via a direct request to (1) wp-includes/vars.php, (2)
wp-content/plugins/hello.php, (3) wp-admin/upgrade-functions.php, (4)
wp-admin/edit-form.php, (5) wp-settings.php, and (6)
wp-admin/edit-form-comment.php, which leaks the path in an error
message related to undefined functions or failed includes.  NOTE: the
wp-admin/menu-header.php vector is already covered by CVE-2005-2110.
NOTE: the vars.php, edit-form.php, wp-settings.php, and
edit-form-comment.php vectors were also reported to affect WordPress
2.0.1.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://echo.or.id/adv/adv24-theday-2005.txt
http://www.vuxml.org/freebsd/e0b342a1-d2ae-11da-a672-000e0c2e438a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: wordpress";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"wordpress");
if(!isnull(bver) && revcomp(a:bver, b:"1.5.2")<0) {
    security_note(0, data:"Package wordpress version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
