#
#VID f92e1bbc-5e18-11d9-839a-0050da134090
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52247);
 script_cve_id("CVE-2004-1294");
 script_version ("$");
 name = "FreeBSD Ports: tnftp";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: tnftp

CVE-2004-1294
The mget function in cmds.c for tnftp 20030825 allows remote FTP
servers to overwrite arbitrary files via FTP responses containing file
names with / (slash) characters.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://tigger.uic.edu/~jlongs2/holes/tnftp.txt
http://cvsweb.netbsd.org/bsdweb.cgi/othersrc/usr.bin/tnftp/src/cmds.c?rev=1.1.1.3&content-type=text/x-cvsweb-markup
http://it.slashdot.org/article.pl?sid=04/12/15/2113202
http://marc.theaimsgroup.com/?l=bugtraq&m=110321888413132
http://www.vuxml.org/freebsd/f92e1bbc-5e18-11d9-839a-0050da134090.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: tnftp";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"tnftp");
if(!isnull(bver) && revcomp(a:bver, b:"20050103")<0) {
    security_note(0, data:"Package tnftp version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
