#
#VID 8f483746-d45d-11dd-84ec-001fc66e7203
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 8f483746-d45d-11dd-84ec-001fc66e7203
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63094);
 script_cve_id("CVE-2008-5619");
 script_version ("$");
 name = "FreeBSD Ports: roundcube";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: roundcube

CVE-2008-5619
html2text.php in RoundCube Webmail (roundcubemail) 0.2-1.alpha and
0.2-3.beta allows remote attackers to execute arbitrary code via
crafted input that is processed by the preg_replace function with the
eval switch.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://trac.roundcube.net/ticket/1485618
http://www.vuxml.org/freebsd/8f483746-d45d-11dd-84ec-001fc66e7203.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: roundcube";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"roundcube");
if(!isnull(bver) && revcomp(a:bver, b:"0.2.b2,1")<0) {
    security_note(0, data:"Package roundcube version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
