#
#VID 57c705d6-12ae-11dd-bab7-0016179b2dd5
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60887);
 script_cve_id("CVE-2008-1382");
 script_bugtraq_id(28770);
 script_version ("$");
 name = "FreeBSD Ports: png";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: png

CVE-2008-1382
libpng 1.0.6 through 1.0.32, 1.2.0 through 1.2.26, and 1.4.0beta01
through 1.4.0beta19 allows context-dependent attackers to cause a
denial of service (crash) and possibly execute arbitrary code via a
PNG file with zero length 'unknown' chunks, which trigger an access of
uninitialized memory.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/29792
http://libpng.sourceforge.net/Advisory-1.2.26.txt
http://www.vuxml.org/freebsd/57c705d6-12ae-11dd-bab7-0016179b2dd5.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: png";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"png");
if(!isnull(bver) && revcomp(a:bver, b:"1.2.27")<0) {
    security_note(0, data:"Package png version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
