#
#VID d9dc2697-dadf-11da-912f-00123ffe8333
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56643);
 script_cve_id("CVE-2006-1812", "CVE-2006-1813");
 script_version ("$");
 name = "FreeBSD Ports: phpwebftp";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: phpwebftp

CVE-2006-1812
phpWebFTP 3.2 and earlier stores script.js under the web document root
with insufficient access control, which allows remote attackers to
obtain sensitive information.

CVE-2006-1813
Directory traversal vulnerability in index.php in phpWebFTP 3.2 and
earlier allows remote attackers to read arbitrary files via a .. (dot
dot) in the language parameter.

Solution:
Update your system with the appropriate patches or
software upgrades.

https://sourceforge.net/forum/forum.php?forum_id=566199
http://secunia.com/advisories/19706/
http://www.vuxml.org/freebsd/d9dc2697-dadf-11da-912f-00123ffe8333.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: phpwebftp";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"phpwebftp");
if(!isnull(bver) && revcomp(a:bver, b:"3.3")<0) {
    security_note(0, data:"Package phpwebftp version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
