#
#VID a2074ac6-124c-11de-a964-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID a2074ac6-124c-11de-a964-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63632);
 script_cve_id("CVE-2008-5557");
 script_bugtraq_id(32948);
 script_version ("$");
 name = "FreeBSD Ports: php4-mbstring";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   php4-mbstring
   php5-mbstring

CVE-2008-5557
Heap-based buffer overflow in
ext/mbstring/libmbfl/filters/mbfilter_htmlent.c in the mbstring
extension in PHP 4.3.0 through 5.2.6 allows context-dependent
attackers to execute arbitrary code via a crafted string containing an
HTML entity, which is not properly handled during Unicode conversion,
related to the (1) mb_convert_encoding, (2) mb_check_encoding, (3)
mb_convert_variables, and (4) mb_parse_str functions.

Solution:
Update your system with the appropriate patches or
software upgrades.


Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: php4-mbstring";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"php4-mbstring");
if(!isnull(bver) && revcomp(a:bver, b:"4.4.9")<0) {
    security_note(0, data:"Package php4-mbstring version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-mbstring");
if(!isnull(bver) && revcomp(a:bver, b:"5.2.9")<0) {
    security_note(0, data:"Package php5-mbstring version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
