#
#VID 402ae710-26a2-11dd-ae05-825f4c35000a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(61056);
 script_cve_id("CVE-2008-2040");
 script_bugtraq_id(28986);
 script_version ("$");
 name = "FreeBSD Ports: peercast";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: peercast

CVE-2008-2040
Stack-based buffer overflow in the HTTP::getAuthUserPass function
(core/common/http.cpp) in Peercast 0.1218 and gnome-peercast allows
remote attackers to cause a denial of service (crash) and possibly
execute arbitrary code via a Basic Authentication string with a long
(1) username or (2) password.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/30020
http://www.vuxml.org/freebsd/402ae710-26a2-11dd-ae05-825f4c35000a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: peercast";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"peercast");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package peercast version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
