#
#VID d177d9f9-e317-11d9-8088-00123f0f7307
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54209);
 script_cve_id("CVE-2001-0910", "CVE-2002-0113", "CVE-2002-0114");
 script_bugtraq_id(3564,3840,3842);
 script_version ("$");
 name = "FreeBSD Ports: nwclient";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: nwclient

CVE-2001-0910
Legato Networker before 6.1 allows remote attackers to bypass access
restrictions and gain privileges on the Networker interface by
spoofing the admin server name and IP address and connecting to
Networker from an IP address whose hostname can not be determined by a
DNS reverse lookup.

CVE-2002-0113
Legato NetWorker 6.1 stores log files in the /nsr/logs/ directory with
world-readable permissions, which allows local users to read sensitive
information and possibly gain privileges.

CVE-2002-0114
Legato NetWorker 6.1 stores passwords in plaintext in the daemon.log
file, which allows local users to gain privileges by reading the
password from the file.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://portal1.legato.com/resources/bulletins/372.html
http://www.vuxml.org/freebsd/d177d9f9-e317-11d9-8088-00123f0f7307.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: nwclient";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"nwclient");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package nwclient version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
