#
#VID eeae6cce-d05c-11d9-9aed-000e0c2e438a
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(54201);
 script_cve_id("CVE-2005-1636");
 script_bugtraq_id(13660);
 script_version ("$");
 name = "FreeBSD Ports: mysql-server";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: mysql-server

CVE-2005-1636
mysql_install_db in MySQL 4.1.x before 4.1.12 and 5.x up to 5.0.4
creates the mysql_install_db.X file with a predictable filename and
insecure permissions, which allows local users to execute arbitrary
SQL commands by modifying the file's contents.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.zataz.net/adviso/mysql-05172005.txt
http://www.vuxml.org/freebsd/eeae6cce-d05c-11d9-9aed-000e0c2e438a.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: mysql-server";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mysql-server");
if(!isnull(bver) && revcomp(a:bver, b:"4.1")>0 && revcomp(a:bver, b:"4.1.12")<0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"5.0")>0 && revcomp(a:bver, b:"5.0.6")<0) {
    security_note(0, data:"Package mysql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
