#
#VID 104beb63-af4d-11da-8414-0013d4a4a40e
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56392);
 script_cve_id("CVE-2006-0579");
 script_version ("$");
 name = "FreeBSD Ports: mplayer, mplayer-gtk, mplayer-esound, mplayer-gtk-esound";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   mplayer
   mplayer-gtk
   mplayer-esound
   mplayer-gtk-esound

CVE-2006-0579
Multiple integer overflows in (1) the new_demux_packet function in
demuxer.h and (2) the demux_asf_read_packet function in demux_asf.c in
MPlayer 1.0pre7try2 and earlier allow remote attackers to execute
arbitrary code via an ASF file with a large packet length value.
NOTE: the provenance of this information is unknown; portions of the
details are obtained from third party information.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.mplayerhq.hu/design7/news.html#vuln13
http://secunia.com/advisories/18718
http://bugs.gentoo.org/show_bug.cgi?id=122029
http://www.vuxml.org/freebsd/104beb63-af4d-11da-8414-0013d4a4a40e.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: mplayer, mplayer-gtk, mplayer-esound, mplayer-gtk-esound";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"mplayer");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7_11")<0) {
    security_note(0, data:"Package mplayer version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7_11")<0) {
    security_note(0, data:"Package mplayer-gtk version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7_11")<0) {
    security_note(0, data:"Package mplayer-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mplayer-gtk-esound");
if(!isnull(bver) && revcomp(a:bver, b:"0.99.7_11")<0) {
    security_note(0, data:"Package mplayer-gtk-esound version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
