#
#VID bf2e7483-d3fa-440d-8c6e-8f1f2f018818
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52995);
 script_cve_id("CVE-2002-0029", "CVE-2004-0083", "CVE-2004-0084", "CVE-2004-0106", "CVE-2004-0687", "CVE-2004-0688", "CVE-2004-0692", "CVE-2004-0914");
 script_version ("$");
 name = "FreeBSD Ports: linux_base";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: linux_base

A number of vulnerabilities have been resolved in the
above package. For details of the issues resolved, please
visit the referenced CVE notices.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://fedoralegacy.org/updates/RH7.3/2004-10-23-FLSA_2004_1947__Updated_glibc_packages_fix_flaws.html
http://rhn.redhat.com/errata/RHSA-2004-059.html
http://rhn.redhat.com/errata/RHSA-2004-478.html
http://rhn.redhat.com/errata/RHSA-2004-612.html
http://www.vuxml.org/freebsd/bf2e7483-d3fa-440d-8c6e-8f1f2f018818.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: linux_base";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"linux_base");
if(!isnull(bver) && revcomp(a:bver, b:"7.3")<0) {
    security_note(0, data:"Package linux_base version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
