#
#VID 847ade05-6717-11d8-b321-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52513);
 script_bugtraq_id(9718);
 script_cve_id("CVE-2004-0110");
 script_version ("$");
 name = "FreeBSD Ports: libxml2";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: libxml2

CVE-2004-0110
Buffer overflow in the (1) nanohttp or (2) nanoftp modules in XMLSoft
Libxml2 2.6.0 through 2.6.5 allow remote attackers to execute
arbitrary code via a long URL.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.xmlsoft.org/news.html
http://mail.gnome.org/archives/xml/2004-February/msg00070.html
http://www.vuxml.org/freebsd/847ade05-6717-11d8-b321-000a95bc6fae.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: libxml2";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"libxml2");
if(!isnull(bver) && revcomp(a:bver, b:"2.6.6")<0) {
    security_note(0, data:"Package libxml2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
