#
#VID 5c7bb4dd-6a56-11d9-97ec-000c6e8f12ef
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52223);
 script_cve_id("CVE-2005-0129", "CVE-2005-0130", "CVE-2005-0131");
 script_version ("$");
 name = "FreeBSD Ports: konversation";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: konversation

CVE-2005-0129
The Quick Buttons feature in Konversation 0.15 allows remote attackers
to execute certain IRC commands via a channel name containing '%'
variables, which are recursively expanded by the
Server::parseWildcards function when the Part Button is selected.

CVE-2005-0130
Certain Perl scripts in Konversation 0.15 allow remote attackers to
execute arbitrary commands via shell metacharacters in (1) channel
names or (2) song names that are not properly quoted when the user
runs IRC sripts.

CVE-2005-0131
The Quick Connection dialog in Konversation 0.15 inadvertently uses
the user-provided password as the nickname instead of the
user-provided nickname when connecting to the IRC server, which could
leak the password to other users.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=full-disclosure&m=110616016509114
http://www.vuxml.org/freebsd/5c7bb4dd-6a56-11d9-97ec-000c6e8f12ef.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: konversation";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"konversation");
if(!isnull(bver) && revcomp(a:bver, b:"0.15")<0) {
    security_note(0, data:"Package konversation version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
