#
#VID 641859e8-eca1-11d8-b913-000c41e2cdad
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52398);
 script_cve_id("CVE-2004-0717", "CVE-2004-0718", "CVE-2004-0721");
 script_version ("$");
 name = "FreeBSD Ports: kdelibs";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   kdelibs
   kdebase
   linux-opera
   opera
   firefox
   linux-mozilla
   linux-mozilla-devel
   mozilla-gtk1
   mozilla
   netscape7

CVE-2004-0717
Opera 7.51 for Windows and 7.50 for Linux does not properly prevent a
frame in one domain from injecting content into a frame that belongs
to another domain, which facilitates web site spoofing and other
attacks, aka the frame injection vulnerability.

CVE-2004-0718
The (1) Mozilla 1.6, (2) Firebird 0.7, (3) Firefox 0.8, and (4)
Netscape 7.1 web browsers do not properly prevent a frame in one
domain from injecting content into a frame that belongs to another
domain, which facilitates web site spoofing and other attacks, aka the
frame injection vulnerability.

CVE-2004-0721
Konqueror 3.1.3, 3.2.2, and possibly other versions does not properly
prevent a frame in one domain from injecting content into a frame that
belongs to another domain, which facilitates web site spoofing and
other attacks, aka the frame injection vulnerability.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/11978/
http://bugzilla.mozilla.org/show_bug.cgi?id=246448
ftp://ftp.kde.org/pub/kde/security_patches/post-3.2.3-kdelibs-htmlframes.patch
ftp://ftp.kde.org/pub/kde/security_patches/post-3.2.3-kdebase-htmlframes.patch
http://www.vuxml.org/freebsd/641859e8-eca1-11d8-b913-000c41e2cdad.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: kdelibs";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"kdelibs");
if(!isnull(bver) && revcomp(a:bver, b:"3.2.3_3")<0) {
    security_note(0, data:"Package kdelibs version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"kdebase");
if(!isnull(bver) && revcomp(a:bver, b:"3.2.3_1")<0) {
    security_note(0, data:"Package kdebase version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-opera");
if(!isnull(bver) && revcomp(a:bver, b:"7.50")>=0 && revcomp(a:bver, b:"7.52")<0) {
    security_note(0, data:"Package linux-opera version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"opera");
if(!isnull(bver) && revcomp(a:bver, b:"7.50")>=0 && revcomp(a:bver, b:"7.52")<0) {
    security_note(0, data:"Package opera version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"firefox");
if(!isnull(bver) && revcomp(a:bver, b:"0.9")<0) {
    security_note(0, data:"Package firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-mozilla");
if(!isnull(bver) && revcomp(a:bver, b:"1.7")<0) {
    security_note(0, data:"Package linux-mozilla version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-mozilla-devel");
if(!isnull(bver) && revcomp(a:bver, b:"1.7")<0) {
    security_note(0, data:"Package linux-mozilla-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mozilla-gtk1");
if(!isnull(bver) && revcomp(a:bver, b:"1.7")<0) {
    security_note(0, data:"Package mozilla-gtk1 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"mozilla");
if(!isnull(bver) && revcomp(a:bver, b:"1.7,2")<0) {
    security_note(0, data:"Package mozilla version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"netscape7");
if(!isnull(bver) && revcomp(a:bver, b:"7.2")<0) {
    security_note(0, data:"Package netscape7 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
