#
#VID ee23aa09-a175-11de-96c0-0011098ad87f
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID ee23aa09-a175-11de-96c0-0011098ad87f
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64893);
 script_version ("$");
 script_name("FreeBSD Ports: horde-base");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: horde-base

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.horde.org/ticket/?id=8311
http://bugs.horde.org/ticket/?id=8399
http://cvs.horde.org/diff.php/horde/docs/CHANGES?r1=1.515.2.558&r2=1.515.2.559
http://www.vuxml.org/freebsd/ee23aa09-a175-11de-96c0-0011098ad87f.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: horde-base");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"horde-base");
if(!isnull(bver) && revcomp(a:bver, b:"3.3.5")<0) {
    security_note(0, data:"Package horde-base version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
